#-----------------------------------------------------------------------
package Album;
#-----------------------------------------------------------------------
$VERSION = 0.03;  #March 23, 2004

# Album.pm - a module to aid in creating album pages for denverhughes.net

#Copyright (C) 2004 Mark Hughes

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# A copy of the GNU General Public License accompanies this program.  It is
# also available from the Free Software Foundation, Inc., 
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;
use Template;


our $AUTOLOAD;
{
my %_attrib_available = (
      templateconfig => 'configuration variables for the Template module',
      imagelist  => 'ref to list of images to be processed',
      title  => '',
      subtitle => '',
      month  => '',
      year => 9999,
      firstyear=> 'year of first album pages',
      server => 'name of webserver',
      username => 'username for webserver',
      password => 'password for webserver',
      serverdir => 'album directory on server',
      basedir => 'the album directory on the local computer',
      destdir => 'the directory that will contain the new album files, usually of the form basedir/year/month04',
      subdir => 'basedir/subdir/albdir is the same as destdir',
      albdir => 'see above',
      rel_destdir => 'relative path to dest directory',
      sourcedir=>'directory containing photos to be placed in album',
      shrt_alb_name => 'name of the directory that contains the album index file',
      prevalbum => 'name of the album subdir',
      prevalbumdir  => 'full directory path',
      rel_prevalbum => 'relative path to the prev album directory',
      previmage => 'filename',
      rel_previmage => 'relative path to previmage',
      bigmax => 'maximum dimension of thumbnail',
      thumbmax=> 'maximum dimension of big, linked image',
      banmax => ' max dimension of banner image',

                  );

my %_fields;
foreach my $key (keys %_attrib_available){
  my $internal_field = '_'.$key; # the internal field begins with an underscore
  $_fields{$internal_field} = undef;
}

sub new {
  my $that = shift;
  my $class = ref($that) || $that;
  my Album $self = {
    _permitted => \%_fields,
    %_fields,
  };
  bless $self, $class;
  # set default values
  my ($month, $year) = date_string();
  $self->set_month($month);
  $self->set_year($year);
  $self->set_shrt_alb_name('NewAlbum');
  $self->set_thumbmax('200');
  $self->set_bigmax('800');
  $self->set_banmax('90');
  return $self;
}

} # end of class methods

sub AUTOLOAD {
  my $self = $_[0];
  my $type = ref($self) || die "$self is not an object\n";
  my $name = $AUTOLOAD;
  return if ($AUTOLOAD =~ /DESTROY/);
  my $meth_type;
  if ($name =~ m:.*([SsGg][Ee][Tt])_:){
    $meth_type = lc($1);
  }
  $name =~ s/.*://;
  $name =~ s/.*[SsGg][Ee][Tt]_//;
  my $field_name = lc('_'.$name);
  unless (exists $self->{_permitted}->{$field_name} ) {
    die "Album: Can't access '$field_name' field in class $type";
  }
  if (@_ && $meth_type eq 'set') {
    return $self->{$field_name} = $_[1];
  } else {
    return $self->{$field_name};
  }
}

sub get_shrt_months_list {
  print "into get_shrt_months\n";
  return ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug',  'Sep',  'Oct', 'Nov',  'Dec'];
}

sub get_vars {
  my $album = shift;
  my $vars = {
      imagelist  => $album->get_imagelist,
      title  => $album->get_title,
      subtitle => $album->get_subtitle,
      month  => $album->get_month,
      year => $album->get_year,
      rel_prevalbum  =>$album->get_rel_prevalbum,
      rel_previmage => $album->get_rel_previmage,
      previmage => $album->get_previmage
                  };
}

sub set_dir_names {  # give a sequential number to the new directory
print "into dir names\n";
  my $album = $_[0];
  my $type = ref($album) || die "$album is not an album object\n";
  my $base_dir = $album->get_basedir;
  my $month = $album->get_month;
  my $months_list = $album->get_shrt_months_list;
  my $year = $album->get_year;
  my $first_year = $album->get_firstyear;
  my $dir_name = $album->get_shrt_alb_name;
  my %month_dir = (
     January => 0, February => 1, March => 2, April => 3, May => 4, June => 5, July => 6, August => 7, September => 8, October => 9,
     November => 10, December => 11
  );
  my $month_no = $month_dir{$month};
  my $dest_dir = $base_dir."/$year/".$$months_list[$month_no].substr( $year, 2 );
  my @list;
  my $prev_month_dir = $dest_dir;
  my $cur_album_no = 0;
  my $prev_album = '';
  my $prev_month_no = $month_no;
  my $prev_year = $year; #changed April 5
  opendir(DESTDIR, $dest_dir) or die "can't opendir $dest_dir: $!\n";
     while(defined(my $name = readdir(DESTDIR))){ 
     next if $name =~ /^\.\.?$/;  #skip . and ..
     push (@list, $name);
  }
  close DESTDIR;
  @list = map  { $_->[0] } sort { $b->[1] <=> $a->[1] }  map  { [ $_, /^(\d+)-.*/] } @list;  
  if ($list[0]) {
       $prev_album = $list[0];
        $list[0] =~ s/-.*$//;
        $cur_album_no = $list[0]+1
  } else {
     $prev_month_no = $month_no;
     $prev_year = $year;
     while ($prev_album eq ''){
        ($prev_month_no, $prev_year) = go_back_one_dir ($prev_month_no, $prev_year);
        if ($prev_year < $first_year) {
          $prev_album = 'PREVALBUM';
          last;
        }
        my @prevlist;
        $prev_month_dir = $base_dir."/$prev_year/".$$months_list[$prev_month_no].substr( $prev_year, 2 );
        print "chk for $prev_month_dir\n";
        next if (! -d $prev_month_dir);
        opendir(PREVMONTH, $prev_month_dir) or  warn "can't opendir $prev_month_dir: $!\n";
        while(defined(my $album = readdir(PREVMONTH))){ 
          next if $album =~ /^\.\.?$/;  #skip . and ..
          push (@prevlist, $album);
        }
        close PREVMONTH;
        @prevlist = map  { $_->[0] } sort { $b->[1] <=> $a->[1] }  map  { [ $_, /^(\d+)-.*/] } @prevlist;  
        if ($prevlist[0]) {
          $prev_album = $prevlist[0];
        }
      } 
      $cur_album_no = 1;
   }
   $album->set_subdir("$year/".$$months_list[$month_no].substr( $year, 2 ));
   $album->set_albdir("$cur_album_no-$dir_name");
   $album->set_destdir("$dest_dir/$cur_album_no-$dir_name");
   $album->set_rel_destdir("../../../$year/".$$months_list[$month_no].substr( $year, 2 )."/$cur_album_no-$dir_name"  );
   $album->set_prevalbum($prev_album);
   $album->set_prevalbumdir("$prev_month_dir/$prev_album");
   $album->set_rel_prevalbum("../../../$prev_year/".$$months_list[$prev_month_no].substr( $year, 2 )."/$prev_album");
}

sub find_previmage {
  my ($album) = shift;
  if ($album->get_prevalbum eq 'PREVALBUM'){
    $album->set_previmage('PREVIMAGE');
    return;
  }
  my $prev_dir = $album->get_prevalbumdir;
  my $rel_prev_dir = $album->get_rel_prevalbum;
  my @list;
  opendir (PREVDIR, "$prev_dir/pages") or warn "Album: can't open $prev_dir: $!\n";
  while(defined(my $name = readdir(PREVDIR))){ 
    next if $name =~ /^\.\.?$/;  #skip . and ..
    next if !($name =~ /\.htm$/);
    $name =~ s/\.htm//;
    push (@list, $name);
  }
  close PREVDIR;
  @list = sort {$b cmp $a} @list;  
  if ($list[0]) {
    $album->set_previmage("$prev_dir/pages/$list[0]");
    $album->set_rel_previmage("../$rel_prev_dir/pages/$list[0]");
  } else {
     $album->set_previmage('PREVIMAGE');
  }
}

sub create_imagelist {
  my ($album) = shift;
  my $source_dir = $album->get_sourcedir;
  print "into imagelist basedir is: $source_dir\n";
  my @image_list;
  opendir(SOURCEDIR, $source_dir) or die "can't opendir $source_dir: $!\n";
  while(defined(my $image = readdir(SOURCEDIR))){ 
    next if $image =~ /^\.\.?$/;  #skip . and ..
    next if !($image =~ /\.jpg$/);
    next if ($image =~/ban_image/);  #should set a flag here to tell create image that there is or is not a ban_image
    $image =~s/\.jpg//;
    push (@image_list, $image);
  }
  close SOURCEDIR;
   @image_list = sort @image_list;
  $album->set_imagelist( \@image_list);
}

sub album_init {
  my ($album) = shift;
  print "into dir_setup: @_\n";
  my $base_dir = $album->get_basedir;
  my $month = $album->get_month;
  my $year = $album->get_year;
  my $months_list= get_shrt_months_list;
  my %month_dir = (
     January => 0, February => 1, March => 2, April => 3, May => 4, June => 5, July => 6, August => 7, September => 8, October => 9,
     November => 10, December => 11
  );
  my $month_no = $month_dir{$month};
 
  if ( ! (is_directory("$base_dir/$year"))) {
    mkdir ("$base_dir/$year");
  }
  if ( ! (is_directory("$base_dir/$year/$month"))) {
    mkdir ("$base_dir/$year/$$months_list[$month_no]".substr( $year, 2 ));
  }
  $album->set_dir_names;
  $album->find_previmage;
  $album->create_imagelist;
  my $dest_dir=$album->get_destdir;
  mkdir ($dest_dir);
  mkdir ("$dest_dir/images");
  mkdir ("$dest_dir/thumbnails");
  mkdir ("$dest_dir/pages");
  print "out of dir init\n";
}

sub create_index {
print "into create index\n";
  my $album = shift;
  my $config= $album->get_templateconfig;
  my $destdir= $album->get_destdir;
  my $index_file = $destdir.'/index.htm';
  my $vars = $album->get_vars;
  my $index_template = Template->new($config);
  my $input = 'index_body';
  $index_template->process($input, $vars, $index_file)
       or die $index_template->error();
}

sub create_images {
  print "into create_images\n";
  my $album = shift;
  my $source_dir = $album->get_sourcedir;
  my $dest_dir = $album->get_destdir;
  my $thumbsize =$album->get_thumbmax;
  my $bigsize = $album->get_bigmax;
  my $bansize = $album->get_banmax;
  my $image_list_ref = $album->get_imagelist;
  my @image_list = @$image_list_ref;
  if (-f "$source_dir/ban_image.jpg") {push @image_list, 'ban_image'};
  $thumbsize = $thumbsize.'x'.$thumbsize;
  $bigsize = $bigsize.'x'.$bigsize;
  $bansize = $bansize.'x'.$bansize;
  foreach my $image (@image_list){
    system ("cp  \'$source_dir/$image.jpg\' \'$dest_dir/thumbnails\'");
    if ($image eq 'ban_image'){
      system( "mogrify -size $bansize -resize $bansize +profile \"*\" \'$dest_dir/thumbnails/$image.jpg\' ");
      print "reducing $image.jpg to bannner size\n";
    } else {
      system ("cp  \'$source_dir/$image.jpg\' \'$dest_dir/images\'");
      system( "mogrify -size $thumbsize -resize $thumbsize +profile \"*\" \'$dest_dir/thumbnails/$image.jpg\'  ");
      print "reducing $image.jpg to a thumbnail\n";
      system( "mogrify -size $bigsize -resize $bigsize +profile \"*\" \'$dest_dir/images/$image.jpg\' ");
      print "reducing $image.jpg to page size\n";
    }
  }
}

sub create_pages {
print "into create pages\n";
  my $album = shift;
  my $dest_dir = $album->get_destdir;
  my $config = $album->get_templateconfig;
  my $vars = $album->get_vars;
  my @image_list = @{$album->get_imagelist};
  my $page_dir = "$dest_dir/pages/";
  my $i = 0;
  foreach my $image (@image_list){
    $$vars{'nextimage'} = $image_list[$i + 1];
    if ($i > 0){$$vars{'previmage'} = $image_list[$i - 1]  # if it's not the first image, link it to prev in this group
      } else {
      $$vars{'previmage'} = $$vars{'rel_previmage'};
     }        
    if ($i == $#image_list) {$$vars{'nextimage'} = 'NEXTIMAGE'}; # if its the last image, put in a placeholder
    $$vars{image} = $image;
    my $index_template = Template->new($config);
    my $input = 'page_body';
    $index_template->process($input, $vars, $page_dir."$image.htm")
           or die $index_template->error();
    $i++;
  };
}

sub do_prevlinks {
  use Tie::File;
  my ($album) = shift;
  my $prev_album = $album->get_prevalbumdir;
  return if ($album->get_prevalbum eq 'PREVALBUM');
  my $prev_page = $album->get_previmage;
  my $rel_destdir = $album->get_rel_destdir;
#  my $rel_prevalbum = $album->get_rel_prevalbum;
  my $image_list = $album->get_imagelist;
  tie my @impage, 'Tie::File', "$prev_page.htm" or die "cannot open $prev_page: $!";
  print "opening $prev_page.htm to look for NEXTIMAGE\n";
  for (@impage) {
    my $image_page = "../$rel_destdir/pages/$$image_list[0]";
    s/NEXTIMAGE/$image_page/g;         
  }
  print "opening $prev_album/index.htm to look for NEXTALBUM\n";
  tie my @albpage, 'Tie::File', "$prev_album/index.htm" or die "cannot open $prev_album: $!";
  for (@albpage) {
    my $index_file = "$rel_destdir/index.htm";
    s/NEXTALBUM/$index_file/g;         
  }
}

sub go_back_one_dir {
  print "into go_back_one_dir\n";
  my ($month_no, $year) = @_;
  $month_no = $month_no -1;
   if ($month_no < 0){
     $month_no = 11;
      $year = $year-1;
   }
   return $month_no, $year;
}

sub is_directory {
  my ($directory) = @_;
  my $flag = 0;
  for ($directory){
    my $is_dir = -d;
    if (defined ( $is_dir) ){
      $flag = 1;
     }
  }
  return $flag;
}
sub setup_gui{ # gui to collect values needed to make album
  use Tk;
  use Tk::LabEntry;
  my $album = shift;
  my $sourcedir = $album->get_sourcedir;
  my $basedir = $album->get_basedir;
  my $month = $album->get_month;
  my $year = $album->get_year;
  my $shrt_alb_name = $album->get_shrt_alb_name;
  my $thumbmax = $album->get_thumbmax;
  my $bigmax = $album->get_bigmax;
  my $banmax = $album->get_banmax;
  my $title;
  my $subtitle;
  my $finished=0;

  my $label_width = '20';
  
  my $mainwindow = MainWindow->new();
  $mainwindow->title ('Create Web Photo Album');
  my $left =$mainwindow->Frame()-> pack( -side => 'left', -fill => 'y', -expand => 'y' );
  my $right=$mainwindow->Frame(-width => '30')-> pack( -side => 'right', -fill => 'x', -expand => 'y');
  
  $left->Label(-text => 'CREATE WEB PHOTO ALBUM ', -fg=>'red')->pack(-anchor=>'w');
  $left->Label(-text => 'General Album Info: ', -pady=>'5', -fg=>'maroon')->pack(-anchor=>'w');
  my $month_fld = $left->LabEntry(
       -label => "Month: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $month, -width => '10', -bg=>'white' )->pack(-side => "top", -anchor => 'w');
  my $year_fld = $left->LabEntry(
        -label => "Year: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $year, -width => '5', -bg=>'white' )->pack(-side => "top", -anchor => 'w');
  my $title_fld = $left->LabEntry(
        -label => "Title: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -width => '30', -bg=>'white')->pack(-side => "top", -anchor => 'w');
  my $subtitle_fld = $left->LabEntry(
        -label => "Subtitle: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -width => '50', -bg=>'white')->pack(-side => "top", -anchor => 'w');
# maximum image sizes  
  $left->Label(
        -text => 'Maximum Image Dimension: ', -pady=>'5', -fg=>'maroon')->pack(-anchor=>'w');
  my $thumbmax_fld = $left->LabEntry(
        -label => "Thumbnail Max: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $thumbmax, -width => '4', -bg=>'white')->pack(-side => "top", -anchor => 'w');
  my $bigmax_fld = $left->LabEntry(
        -label => "Linked Image Max: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $bigmax, -width => '4', -bg=>'white')->pack(-side => "top", -anchor => 'w');
  my $banmax_fld = $left->LabEntry(
        -label => "Heading Image Max: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $banmax, -width => '4', -bg=>'white'
        )->pack(-side => "top", -anchor => 'w');
  
# directory selection
  $left->Label(-text => 'Directory Info: ', -pady=>'5', -fg=>'maroon')->pack(-anchor=>'w');
  my $sourcedir_fld = $left->LabEntry(
        -label => "Source Dir: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $sourcedir, -width => '50', -bg=>'white'
        )->pack(-side => "top", -anchor => 'w');
  $left->Button(
        -text=>'Browse',  -command=> [ \&chooseDirectory, $mainwindow, $sourcedir, $sourcedir_fld, 'Choose Dir Containing Photos'] 
        )->pack(-anchor => 'e');        
  my $basedir_fld = $left->LabEntry(
        -label => "Main Album Dir: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $basedir, -width => '50', -bg=>'white'
        )->pack(-side => "top", -anchor => 'w');
  $left->Button(
      -text=>'Browse',  -command=> [ \&chooseDirectory, $mainwindow, $basedir, $basedir_fld, 'Choose Main Album Dir'] )->pack(-anchor => 'e');        
   my $shrt_alb_name_fld = $left->LabEntry(
      -label => "Name of This Alb Dir: ", -labelWidth => $label_width, -labelPack => [ -side => "left"], -labelAnchor => 'e', -textvariable => $shrt_alb_name, -width => '10', -bg=>'white'
      )->pack(-side => "top", -anchor => 'w');
# OK and Cancel buttons
   $left->Button(-text=>'OK',  -command=>[\&set_variables])->pack(-side => 'right');    
   $left->Button(-text=>'Exit',  -command => sub {$finished = -1; exit} )->pack(-side => 'right');    
    
    $left->waitVariable(\$finished);
    $mainwindow->destroy if Tk::Exists($mainwindow);
    if ($finished == 1) {
      return 1;
    } else { 
      undef;
    }
    MainLoop();

    sub set_variables {
      $album->set_sourcedir($sourcedir_fld->get());
      $album->set_title($title_fld->get());
      $album->set_month($month_fld->get());
      $album->set_year($year_fld->get());
      $album->set_subtitle($subtitle_fld->get());
      $album->set_shrt_alb_name( $shrt_alb_name_fld->get());
      $album->set_basedir($basedir_fld->get());
      $album->set_thumbmax($thumbmax_fld->get());
      $album->set_bigmax($bigmax_fld->get());
      $album->set_banmax($banmax_fld->get());
      $finished = 1;
   }
}

sub chooseDirectory {
    my($top, $curr_dir, $entry_field, $title) = @_;
    if (!defined $curr_dir) {
      require Cwd;
      $curr_dir = Cwd::cwd();
    }
    require Tk::DirTree;
    my $t = $top->Toplevel;
    $t->title($title);    
    my $ok = 0; 
    my $f = $t->Frame->pack(-fill => "x", -side => "bottom");
    my $d;
    $d = $t->Scrolled('DirTree',
        -scrollbars => 'osoe',
        -width => 35,
        -height => 20,
        -selectmode => 'browse',
        -exportselection => 1,
        -browsecmd => sub { $curr_dir = shift;
       if ($^O ne 'MSWin32') {
           $curr_dir =~ s|^//|/|; # bugfix
       }
            },

        # With this version of -command a double-click will
        # select the directory
       -command   => sub { $ok = 1 },

        # With this version of -command a double-click will
        # open a directory. Selection is only possible with
        # the Ok button.
        #-command   => sub { $d->opencmd($_[0]) },
       )->pack(-fill => "both", -expand => 1);
    # Set the initial directory
    exists &Tk::DirTree::chdir ? $d->chdir($curr_dir) : $d->set_dir($curr_dir);
        $f->Button(-text => 'OK',  -command => sub { $ok =  1 })->pack(-side => 'right');
    $f->Button(-text => 'Cancel',  -command => sub { $ok = -1})->pack(-side => 'right');

    $f->waitVariable(\$ok);
    $t->destroy if Tk::Exists($t);
    if ($ok == 1) {
      fill_entry($entry_field, $curr_dir);
     $curr_dir;
    } else { 
      undef;
    }
}

sub fill_entry {
  my ($entry, $txt) = @_;
   if (defined $txt and $txt ne '') {
      $entry->delete(0, 'end');
      $entry->insert(0, $txt);
      $entry->xview('end');
    }
}
sub date_string{   
  my @date = localtime();
  my @month_dir = qw(
     January February March  April May June July August September October November December );
  my $month = $month_dir[$date[4]];
  my $year = $date[5]+1900;
  return $month, $year;
}

sub ftp_changes {  
  use Net::FTP;
  my $album  = shift;
  my $serverbase_dir = $album->get_serverdir;
  my $base_dir = $album->get_basedir;
  my $year_dir = $album->get_year;
  my $sub_dir = $album->get_subdir;
  my $dest_dir = $album->get_destdir;
  my $alb_dir = $album->get_albdir;
  my $server_name = $album->get_server;
  my $username = $album->get_username;
  my $password = $album->get_password;
  my $image_list = $album->get_imagelist;
  my $ftp = Net::FTP->new($server_name);
  $ftp->login($username,$password) or die "Cannot login to $server_name", $ftp->message;
  $ftp->pwd;
  if (! $ftp->cwd($serverbase_dir)){
    print "Cannot change working directory to base dir", $ftp->message;
    $ftp->mkdir($serverbase_dir) or warn "Cannot make base directory: ";
    print $ftp->message;
   $ftp->cwd($serverbase_dir) or warn "Cannot change working directory to base dir: ";
    print $ftp->message;
    $ftp->mkdir($year_dir) or warn "Cannot make year directory: ";
    print $ftp->message;
  }
  if (! $ftp->cwd($sub_dir)){
    print "Cannot change working directory to sub dir ", $ftp->message;
    $ftp->mkdir($sub_dir) or warn "Cannot make sub directory: ";
    print $ftp->message;
    $ftp->cwd($sub_dir) or warn "Cannot change working directory to sub dir: ";
    print $ftp->message;
  }
  $ftp->mkdir($alb_dir) or die "Cannot make directory :";
  $ftp->message;
  $ftp->cwd($alb_dir) or warn "Cannot change working directory ", $ftp->message;
  $ftp->mkdir('pages');
  $ftp->mkdir('images');
  $ftp->mkdir('thumbnails');
  $ftp->ascii;
  put_file($ftp, "$dest_dir/index.htm", 'index.htm');
  foreach my $file (@$image_list){ 
    put_file($ftp, "$dest_dir/pages/$file.htm", "pages/$file.htm");
  }
  $ftp->binary;
  foreach my $file (@$image_list){
    put_file($ftp, "$dest_dir/thumbnails/$file.jpg", "thumbnails/$file.jpg");
    put_file($ftp, "$dest_dir/images/$file.jpg", "images/$file.jpg");
  }
  if ( -f "$dest_dir/thumbnails/ban_image.jpg"){
    put_file($ftp, "$dest_dir/thumbnails/ban_image.jpg", "thumbnails/ban_image.jpg");
  }
  my $prev_dir = $album->get_prevalbumdir;
  if ( $album->get_prevalbum eq 'PREVALBUM'){return};
  my $prev_alb = $album->get_rel_prevalbum;
  my $prev_page = $album->get_previmage;
  $ftp->ascii;
  $ftp->cwd($prev_alb);
  put_file($ftp, "$prev_dir/index.htm");
  $ftp->cwd('pages');
  put_file($ftp, "$prev_page.htm");
  $ftp->quit;
}

sub put_file {
  my ($ftp, $local_file, $remote_file) = @_;
  print "putting $local_file\n";
  my $retries = 2;
  my $delay = 5;
  my $success = 0;
  for(my $numtimes = 0; (! $success) && ($numtimes ne $retries); ++$numtimes) {
     $success = $ftp->put($local_file, $remote_file);
#     print $ftp->message;
     if (! $success){
       if ($numtimes ne $retries - 1) {
         print "trying it again in $delay second(s)\n";
       }
       sleep($delay);
     }
  }
  return $success;
}
1;







