#!/usr/bin/perl -w

# createalb.pl - a perl script that creates web photo albums.
# June 31, 2004

#Copyright (C) 2004 Mark Hughes

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# A copy of the GNU General Public License accompanies this program.  It is
# also available from the Free Software Foundation, Inc., 
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

use strict;

# INITIALIZE MODULES
use Template;                                 # this is a standard perl module
use FindBin qw($Bin);
use lib "$Bin/../lib";
use Album;                                     # this is the custom module that is in the /lib subdir

# create an album object
my $album = Album->new;
my $config = {                               # configuration constants for Template module
      INCLUDE_PATH => "$Bin/../templates",
      INTERPOLATE  => 1,                # expand "$var" in plain text
      POST_CHOMP   => 1,              # cleanup whitespace
};
$album->set_templateconfig($config);

# SET DEFAULTS
# set default directories - these can be changed in the GUI
$album->set_sourcedir('/home/mark/Files/PICTUREDIR');# DEFAULT FOR GUI
$album->set_basedir('/home/mark/Files/WEBSITEDIR/Album');  # DEFAULT FOR GUI
# other constants
$album->set_firstyear('1999');     # This is as far back as album will look for previous pages
                                                #  when it attempts to link the previous pages to the new pages

# SET CONSTANTS
# server information
$album->set_server('www.*****.net');
$album->set_password('*****');
$album->set_username('*****');
$album->set_serverdir('/html/Album');

# CREATE GUI AND COLLECT ACTUAL CONSTANTS
$album->setup_gui;

# CHECK VALIDITY OF CONSTANTS  - this isn't complete or neat
if ( ! is_directory($album->get_sourcedir)) {
  die "source directory doesn't exist: $!\n";
}

# CREATE THE ALBUM PAGES
# First, make the pages
$album->album_init;
$album->create_index;
$album->create_pages;
# Second, copy and resize the images
$album->create_images;
# Third, link the new pages to the existing pages
$album->do_prevlinks;
# Fourth, ftp the new & changed pages to the server
$album->ftp_changes;                 
print "Done\n";

#-----------------------------------------------------------------subroutines -----------------------------------------
 
sub is_directory {
  my ($directory) = @_;
  my $flag = 0;
  for ($directory){
    my $is_dir = -d;
    if (defined ( $is_dir) ){
      $flag = 1;
     }
  }
  return $flag;
}

